//lcd_ACM1602_lib_i2c.c
///////////////////////////////////////////////
//  H@LN^t ACM1602NI
//@I2CC^[tF[X@16 x 2s@for PIC32MZ & XC32RpC
//  Vcc: 2.7v -5.5v
//
//@@lcd_ACM1602_init_i2c()    ----- 
//    lcd_ACM1602_cmd_i2c(cmd)  ----- R}ho
//    lcd_ACM1602_data_i2c(chr) ----- P\o
//    lcd_ACM1602_clear_i2c()   ----- S
//    lcd_ACM1602_str_i2c(str*) -----@\
//    lcd_ACM1602_cmd_i2c(0x0C);    //J[\F0FFAuNF0FF
//    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
//    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
//////////////////////////////////////////////


#include    "lcd_ACM1602_lib_i2c.h"

#ifndef MY_INCLUDE_XC_H
#define MY_INCLUDE_XC_H
#include <xc.h> //ǉ
#endif


void lcd_ACM1602_delay_us_i2c(unsigned int usec)        //1secx֐
{
    int count;

	count = (int)(lcd_Clock_i2c/20000000)*usec;

        do      //F@at@200MH (Clock=200000000)
        {       //delay_us(1000)1000.4secA@delay_us(100)100.6secAdelay_us(10)10.5secAdelay_us(1)1.5sec
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");asm("NOP");
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");

                count--;
        }while(count != 0);
}

void lcd_ACM1602_delay_ms_i2c(unsigned int msec)        //1msecx֐
{
     unsigned int i;

	for(i=0; i<msec; i++)
	lcd_ACM1602_delay_us_i2c(1000);
}




void lcd_ACM1602_Reset_i2C(void)
{

    I2CXCONbits.ON = 0;      //IC2W[FOFF
    I2CXCONbits.ON = 1;      //IC2W[FON
}


void lcd_ACM1602_Idle_i2c(void)  //ACh҂
{
     while(I2CXCONbits.SEN || I2CXCONbits.PEN || I2CXCONbits.RCEN
           || I2CXCONbits.ACKEN || I2CXSTATbits.TRSTAT);
}

void lcd_ACM1602_start_i2c(void)    //I2CX^[g
{
    lcd_ACM1602_Idle_i2c();
    I2CXCONbits.SEN = 1;    // X^[go//
    while(I2CXCONbits.SEN); // X^[gI҂
}

void lcd_ACM1602_stop_i2c(void) //I2CXgbv
{
   I2CXCONbits.PEN = 1;     // Xgbvo
    while(I2CXCONbits.PEN); // XgbvI҂

}


void lcd_ACM1602_write_byte_i2c(unsigned char byte)  //1oCg
{

    I2CXTRN = byte;                 // f[^ZbgMJn
    while(I2CXSTATbits.TBF);        // MI҂
    while(I2CXSTATbits.ACKSTAT);    // ACKԐM҂
    lcd_ACM1602_Idle_i2c();                     // ACh҂

}



void lcd_ACM1602_WtiteCommand_i2c(unsigned char command)    //R}hM
{
    lcd_ACM1602_Reset_i2C();            //i2CW[@ăX^[g

    lcd_ACM1602_start_i2c();
    lcd_ACM1602_write_byte_i2c(0xa0);   // AhX{M[hM
    lcd_ACM1602_Idle_i2c();
    lcd_ACM1602_delay_us_i2c(10);

    lcd_ACM1602_write_byte_i2c(0x00);   // WX^w著M
    lcd_ACM1602_Idle_i2c();
    lcd_ACM1602_delay_us_i2c(10);

    lcd_ACM1602_write_byte_i2c(command);// R}hM
    lcd_ACM1602_Idle_i2c();
    lcd_ACM1602_delay_us_i2c(10);


    lcd_ACM1602_stop_i2c();



}


void lcd_ACM1602_WriteData_i2c(unsigned char data)  //f[^M
{
    lcd_ACM1602_Reset_i2C();     //i2CW[@ăX^[g
   
    lcd_ACM1602_start_i2c();
    lcd_ACM1602_write_byte_i2c(0xa0);   // AhX{M[hM
    lcd_ACM1602_Idle_i2c();
    lcd_ACM1602_delay_us_i2c(10);

    lcd_ACM1602_write_byte_i2c(0x80);   // WX^w著M
    lcd_ACM1602_Idle_i2c();
    lcd_ACM1602_delay_us_i2c(10);

    lcd_ACM1602_write_byte_i2c(data);   // f[^M
    lcd_ACM1602_Idle_i2c();
    lcd_ACM1602_delay_us_i2c(10);
    lcd_ACM1602_stop_i2c();
  
}

void lcd_ACM1602_cmd_i2c(unsigned char cmd)
{
  
    lcd_ACM1602_WtiteCommand_i2c(cmd);      //
    lcd_ACM1602_Idle_i2c();

    if((cmd == 0x01)||(cmd == 0x02))    // Clear or HomeR}h̏ꍇ
        lcd_ACM1602_delay_ms_i2c(3);        // 3msec҂
    else
        lcd_ACM1602_delay_us_i2c(60);       //60sec҂
}


void lcd_ACM1602_init_i2c(void)     //t
{

    lcd_ACM1602_delay_ms_i2c(100);

    lcd_ACM1602_cmd_i2c(0x01);      //WtiteCommand(0x01);
    lcd_ACM1602_delay_ms_i2c(5);   //delay at least 5ms

   
    lcd_ACM1602_cmd_i2c(0x38);      //WtiteCommand(0x38);
    lcd_ACM1602_delay_ms_i2c(5);   //delay at least 5ms


  
    lcd_ACM1602_cmd_i2c(0x0f);      //WtiteCommand(0x0f);
    lcd_ACM1602_delay_ms_i2c(5);           //delay at least 5ms

   
    lcd_ACM1602_cmd_i2c(0x0f);      //WtiteCommand(0x06);
    lcd_ACM1602_delay_ms_i2c(5);   //delay at least 5ms


}


void lcd_ACM1602_data_i2c(unsigned char data)   //P\
{
    lcd_ACM1602_WriteData_i2c(data);    //
    lcd_ACM1602_delay_us_i2c(30);   //delay_us(30); // x
}


void lcd_ACM1602_clear_i2c(void)    //ʃNA
{
    lcd_ACM1602_cmd_i2c(0x01);          //R}ho
}


void lcd_ACM1602_str_i2c(const unsigned char* str)  //\
{
    while(*str != 0)			////I[ '\0'o܂
        lcd_ACM1602_data_i2c(*str++);		//1\
}